//==============================================================================
// Project:		Wealth Transfers and their economic effects
// File name:	Box 2.3 figure a
// Objective: 	Generate the data underpinning box 2.3 figure a
//
//==============================================================================


clear all

************************
*** Data import ***
************************

cd "XXXX" //set content directory here

use combined_filtered_restricted.dta, replace

merge m:1 xwaveid wave using bequest_from_HH_death.dta //flag for inheritances due to HH deaths
drop if _merge == 2
drop _merge

merge m:1 xwaveid wave using individual_weight_vars_restricted.dta //individual wealth variables
drop if _merge == 2
drop _merge

xtset xwaveid wave

keep if wave == 18

************************
*** Create variables ***
************************

replace oifinha = 0 if oifinha == -10 | oifinha == -1 //inheritances
replace oifinha = . if oifinha < 0
gen bequest = oifinha
replace bequest = 0 if bequest > 0 & bequest != . & bequest_from_HH_death == 1 //filter out inheritances due HH deaths

replace oifnptr = 0 if oifnptr == -10 //gifts
replace oifnpt = 0 if oifnpt == -10
replace oifnptr = . if oifnptr < 0
gen gift = oifnptr + oifnpt
 
gen net_worth = pwassei - pwdebti //individual net worth

gen bequest_positive = 0
replace bequest_positive = 1 if bequest > 0 & bequest != . //flag for an inheritance
egen total_bequest_positive_age = total(hhwtes) if bequest_positive == 1, by(hgage)
egen total_bequest_positive = total(hhwtes) if bequest_positive == 1
gen share_bequest_positive = total_bequest_positive_age * 100 / total_bequest_positive

gen gift_positive = 0
replace gift_positive = 1 if gift > 0 & gift != . //flag for a gift
egen total_gift_positive_age = total(hhwtes) if gift_positive == 1, by(hgage)
egen total_gift_positive = total(hhwtes) if gift_positive == 1
gen share_gift_positive = total_gift_positive_age * 100 / total_gift_positive

collapse (mean) net_worth (max) share_bequest_positive share_gift_positive [pweight = hhwtes], by(hgage)
replace share_bequest_positive = 0 if share_bequest_positive == .
replace share_gift_positive = 0 if share_gift_positive == .

export delimited age_distribution.csv, replace

